{******************************************************************************}
{                                                                              }
{                                MiniAsmChecker                                }
{                                                                              }
{   Class checking the syntax of a given source-code. Derived from             }
{   TMiniASMSourceWorker.                                                      }
{                                                                              }
{   original author:   Christian Rehn aka r2c2                                 }
{                                                                              }
{   This code is licenced under the terms of the Mozilla Public Licence(MPL)   }
{   See http://www.mozilla.org/MPL/ or licence-file included in surce-archive  }
{   for licence terms.                                                         }
{                                                                              }
{******************************************************************************}

unit MiniAsmChecker;

interface

uses
  MiniAsmSourceWorker, Classes;

type
  TMiniAsmChecker = class(TMiniAsmSourceWorker)
  public
    function Execute(AOutput: TStrings): Boolean; override;
  end;

implementation

uses
  SysUtils;

{ TMiniAsmChecker }

function TMiniAsmChecker.Execute(AOutput: TStrings): Boolean;
var
  i: Integer;
  j: Integer;
  Operation: string;
  Arg: string;
  Labels: TStringList;
  UsedLabels: TStringList;
begin
    Result := True;
  if Source.Count > 0 then
  begin
    RemoveComments;
    Labels := nil;
    UsedLabels := nil;
    try
      Labels := TStringList.Create;
      UsedLabels := TStringList.Create;

      // alle vergebenen und alle benutzen Labels in StringLists packen:
      for i := 0 to Source.Count - 1 do
      begin
        ParseLine(i, Operation, Arg);

        if Syntax.IsLabel(Operation) then
        begin
          Labels.AddObject(Operation, Pointer(i)); // alle vergebenen Labels mitprotokollieren
        end;
        if Syntax.IsLabel(Arg) then
        begin
          UsedLabels.AddObject(Arg, Pointer(i)); // alle benutzten Labels mitprotokollieren
        end;
      end;

      // gucken ob alle benutzten Labels vorhanden sind:
      for i := 0 to UsedLabels.Count - 1 do
      begin
        if Labels.IndexOf(UsedLabels[i]) = -1 then
        begin
          Result := False;
          AOutput.Add(Format('Fehler [Zeile: %d] Das Label %s wurde nicht gefunden',
            [Integer(UsedLabels.Objects[i]), UsedLabels[i]]));
        end;
      end;
      // auf doppelte Labels prfen:
      for i := Labels.Count -1 downto 1 do
      begin
        for j := i - 1 downto 0 do
        begin
          if Labels[i] = Labels[j] then
          begin
            Result := False;
            AOutput.Add(Format('Fehler [Zeile: %d] Das Label %s wurde schon verwendet',
            [Integer(Labels.Objects[i]), Labels[i]]));
          end;
        end;
      end;
      // gucken ob alle vergebenen Labels verwendet wurden:
      for i := 0 to Labels.Count - 1 do
      begin
        if UsedLabels.IndexOf(Labels[i]) = -1 then
        begin
          AOutput.Add(Format('Hinweis [Zeile: %d] Das Label %s wurde nicht verwendet',
            [Integer(Labels.Objects[i]), Labels[i]]));
        end;
      end;

      if Result then // wichtig, da sonst u.U. die Labels nicht ersetzt werden knnen
      begin
        // Prfen ob der Command gltig ist:
        PrepareSource;
        for i := 0 to Source.Count - 1 do
        begin
          ParseLine(i, Operation, Arg);

          if (Operation <> '') and (not Syntax.IsCommand(Operation, Arg))
            and (not Syntax.IsLabel(Operation)) then
          begin
            Result := False;
            AOutput.Add(Format('Fehler [Zeile: %d] %s ist keine gltige Operation oder'
              + ' %s kein passendes Argument.', [i, Operation, Arg]));
          end;
        end;
      end;
      ParseLine(Source.Count -1, Operation, Arg);
      if AnsiLowerCase(Operation) <> Syntax.&end then
      begin
        Result := False;
        AOutput.Add(Format('Fehler [Zeile: %d] %s fehlt.', [Source.Count -1,
          Syntax.&end]));
      end;
    finally
      Labels.Free;
      UsedLabels.Free;
    end;
  end;
end;

end.
