{******************************************************************************}
{                                                                              }
{                                MiniASMStack                                  }
{                                                                              }
{   Simple implementaion of a stack used for storing 32Bit-Integers for        }
{   use with TMiniASMInterpreter                                               }
{                                                                              }
{   original author:   Christian Rehn aka r2c2                                 }
{                                                                              }
{   This code is licenced under the terms of the Mozilla Public Licence(MPL)   }
{   See http://www.mozilla.org/MPL/ or licence-file included in surce-archive  }
{   for licence terms.                                                         }
{                                                                              }
{******************************************************************************}

unit MiniAsmStack;

interface

type
  TStackChangeEvent = procedure(Sender: TObject; AData: array of Integer) of object;
  TMiniAsmStack = class
  private
    FData: array of Integer;
    FOnStackChange: TStackChangeEvent;
    function GetSize: Integer;
    procedure SetSize(AValue: Integer);
    function GetData(index: Integer): Integer;
    procedure SetData(index: Integer; const Value: Integer);
  public
    constructor Create(ASize: Integer);
    property Size: Integer read GetSize write SetSize;
    property Data[index: Integer]: Integer read GetData write SetData; default;
    property OnStackChange: TStackChangeEvent read FOnStackChange write FOnStackChange;
    procedure Push(AValue: Integer);
    function Pop: Integer;
  end;

implementation

constructor TMiniAsmStack.Create(ASize: Integer);
begin
  inherited Create;
  SetLength(FData, ASize);
  if Assigned(FOnStackChange) then
    FOnStackChange(Self, FData);  
end;

function TMiniAsmStack.Pop: Integer;
begin
  Result := FData[0];
  Move(FData[1], FData[0], (Length(FData) -1) * SizeOf(Integer));
  if Assigned(FOnStackChange) then
    FOnStackChange(Self, FData);
end;

procedure TMiniAsmStack.Push(AValue: Integer);
begin
  Move(FData[0], FData[1], (Length(FData) -1) * SizeOf(Integer));
  FData[0] := AValue;
  if Assigned(FOnStackChange) then
    FOnStackChange(Self, FData);
end;

{$REGION 'Getter und Setter'}
     
function TMiniAsmStack.GetData(index: Integer): Integer;
begin
  Result := FData[index];
end;

function TMiniAsmStack.GetSize: Integer;
begin
  Result := Length(FData);
end;

procedure TMiniAsmStack.SetData(index: Integer; const Value: Integer);
begin
  FData[index] := Value;
  if Assigned(FOnStackChange) then
    FOnStackChange(Self, FData);
end;

procedure TMiniAsmStack.SetSize(AValue: Integer);
begin
  SetLength(FData, AValue);
  if Assigned(FOnStackChange) then
    FOnStackChange(Self, FData);  
end;     

{$ENDREGION}
end.
