{******************************************************************************}
{                                                                              }
{                                About                                         }
{                                                                              }
{   Displays an about-box including information about the mnemonics of         }
{   MiniAsm32.                                                                 }
{                                                                              }
{   original author:   Christian Rehn aka r2c2                                 }
{                                                                              }
{   This code is licenced under the terms of the Mozilla Public Licence(MPL)   }
{   See http://www.mozilla.org/MPL/ or licence-file included in source-archive }
{   for licence terms.                                                         }
{                                                                              }
{******************************************************************************}

unit About;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Syntax;

type
  TAboutFRM = class(TForm)
    PageControl1: TPageControl;
    Panel1: TPanel;
    MnemonicsTS: TTabSheet;
    LicenseTS: TTabSheet;
    CloseB: TButton;
    Panel2: TPanel;
    LicenseM: TMemo;
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    MnemonicsM: TMemo;
    ChangeLogTS: TTabSheet;
    ChangeLogM: TMemo;
    CreditsTS: TTabSheet;
    CreditsM: TMemo;
    procedure FormShow(Sender: TObject);
  private
    FSyntax: TSyntax;
  public
    property Syntax: TSyntax read FSyntax write FSyntax;
    function ShowModal(ASyntax: TSyntax): TModalResult; reintroduce;
  end;

implementation

{$R *.dfm}

procedure TAboutFRM.FormShow(Sender: TObject);
begin
  MnemonicsM.Lines.Clear;
  MnemonicsM.Lines.Add('Mnemonics');
  MnemonicsM.Lines.Add('---------');
  MnemonicsM.Lines.Add('');
  MnemonicsM.Lines.Add('(Kommentare beginnen mit einem Semikolon.)');
  MnemonicsM.Lines.Add('');
  if Assigned(FSyntax) then
  begin
    MnemonicsM.Lines.Add('[Standard-Befehle:]');

    if FSyntax.ReadInt <> '' then
      MnemonicsM.Lines.Add(FSyntax.ReadInt + ' N --> Zahl von Console lesen und '
        + 'in Stack an Position N schreiben.');
    MnemonicsM.Lines.Add('');
    if FSyntax.WriteInt <> '' then
      MnemonicsM.Lines.Add(FSyntax.WriteInt + ' N --> Inhalt des Stack an Position '
        + 'N auf Console ausgeben.');
    MnemonicsM.Lines.Add('');
    if FSyntax.Load <> '' then
      MnemonicsM.Lines.Add(FSyntax.Load + ' N --> Inhalt des Stack an Position N'
        + 'in Akku laden');
    MnemonicsM.Lines.Add('');
    if FSyntax.Store <> '' then
      MnemonicsM.Lines.Add(FSyntax.Store + ' N --> Inhalt des Akku in Stack an '
        + 'Position N schreiben');
    MnemonicsM.Lines.Add('');
    if FSyntax.Add <> '' then
      MnemonicsM.Lines.Add(FSyntax.Add + ' N --> Inhalt des Stacks an Position N '
        + 'zu Akku hinzuaddieren.');
    MnemonicsM.Lines.Add('');
    if FSyntax.Substract <> '' then
      MnemonicsM.Lines.Add(FSyntax.Substract + ' N --> Inhalt des Stacks an Position N '
        + 'von Akku subtrahieren.');
    MnemonicsM.Lines.Add('');
    if FSyntax.Mutiply <> '' then
      MnemonicsM.Lines.Add(FSyntax.Mutiply + ' N --> Inhalt des Stacks an Position N '
        + 'mit Akku multiplizieren.');
    MnemonicsM.Lines.Add('');
    if FSyntax.Devide <> '' then
      MnemonicsM.Lines.Add(FSyntax.Devide + ' N --> Akku durch Inhalt des Stacks '
        + 'an Position N dividieren.');
    MnemonicsM.Lines.Add('');
    if FSyntax.&Label <> '' then
      MnemonicsM.Lines.Add(FSyntax.&Label + 'Label --> Label definieren.');
    MnemonicsM.Lines.Add('');
    if FSyntax.Jmp <> '' then
      MnemonicsM.Lines.Add(FSyntax.Jmp + ' ' + FSyntax.&Label + 'Label --> zu '
        + 'Label springen.');
    MnemonicsM.Lines.Add('');
    if FSyntax.Jz <> '' then
      MnemonicsM.Lines.Add(FSyntax.Jz + ' ' + FSyntax.&Label + 'Label --> zu '
        + 'Label springen, wenn das Zero-Flag gesetzt ist.');
    MnemonicsM.Lines.Add('');
    if FSyntax.Jns <> '' then
      MnemonicsM.Lines.Add(FSyntax.Jns + ' ' + FSyntax.&Label + 'Label --> zu '
        + 'Label springen, wenn das Sign-Flag nicht gesetzt ist.');
        MnemonicsM.Lines.Add('');
    if FSyntax.&End <> '' then
      MnemonicsM.Lines.Add(FSyntax.&End + ' --> Ende des Programms.');
    MnemonicsM.Lines.Add('');

    MnemonicsM.Lines.Add('[Zustzliche Befehle:]');

    if FSyntax.Push <> '' then
      MnemonicsM.Lines.Add(FSyntax.Push  + ' --> Inhalt des Akku auf Stack pushen');
    MnemonicsM.Lines.Add('');
    if FSyntax.Pop <> '' then
      MnemonicsM.Lines.Add(FSyntax.Pop + ' --> Oberstes Element aus dem Stack '
        + 'entnehmen und in Akku laden.');
    MnemonicsM.Lines.Add('');
    if FSyntax.GoSub <> '' then
      MnemonicsM.Lines.Add(FSyntax.GoSub + ' Label --> EIP(InstructionPointer) auf '
        + 'Stack pushen und zu Label springen.');
    MnemonicsM.Lines.Add('');
    if FSyntax.Ret <> '' then
      MnemonicsM.Lines.Add(FSyntax.Ret + ' --> an vorher auf Stack gepushte '
        + 'Position zurckspringen.');
    MnemonicsM.Lines.Add('');
    if FSyntax.Data <> '' then
      MnemonicsM.Lines.Add(FSyntax.Data + ' N --> N in akku laden.');
    MnemonicsM.Lines.Add('');
    if FSyntax.Print <> '' then
      MnemonicsM.Lines.Add(FSyntax.Print + ' Text --> Text auf Console ausgeben.');
  end
  else
  begin
    MnemonicsM.Lines.Add('Kann Syntax-Informationen nicht lesen. Syntax nicht gesetzt.');
  end;
end;

function TAboutFRM.ShowModal(ASyntax: TSyntax): TModalResult;
begin
  FSyntax := ASyntax;
  Result := inherited ShowModal;
end;

end.
