{******************************************************************************}
{                                                                              }
{                                Main                                          }
{                                                                              }
{   The main-form of MiniAsm32                                                 }
{                                                                              }
{   original author:   Christian Rehn aka r2c2                                 }
{                                                                              }
{   This code is licenced under the terms of the Mozilla Public Licence(MPL)   }
{   See http://www.mozilla.org/MPL/ or licence-file included in source-archive }
{   for licence terms.                                                         }
{                                                                              }
{******************************************************************************}

//TODO: Optionen
//TODO: AutoSave
//TODO: "Bitte geben Sie..."
//TODO: Zeilenumbruch nach "Bitte geben..."
//TODO: Breakpoints
//TODO: Hexdarst. fr Regsiter, etc.
//TODO: run, cls, shutdown, ...

unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, XPStyleActnCtrls, ActnList, ActnMan, ComCtrls, Menus, ExtCtrls,
  StdCtrls, ToolWin, StdActns, ActnCtrls, ActnMenus, ImgList, Syntax,
  ConsoleMemo, MiniAsmInterpreter, SynEdit, ActnPopup, SynEditHighlighter,
  SynHighlighterGeneral, Grids, ValEdit, XPMan;

type
  TMiniAsmFRM = class(TForm)
    StatusBar1: TStatusBar;
    ErrorsLB: TListBox;
    Splitter1: TSplitter;
    ActionManager1: TActionManager;
    ImageList1: TImageList;
    ActionToolBar1: TActionToolBar;
    EditCut1: TEditCut;
    EditCopy1: TEditCopy;
    EditPaste1: TEditPaste;
    EditSelectAll1: TEditSelectAll;
    EditUndo1: TEditUndo;
    EditDelete1: TEditDelete;
    ActionMainMenuBar1: TActionMainMenuBar;
    FileNew1: TAction;
    FileOpen1: TAction;
    FileSave1: TAction;
    FileSaveAs1: TAction;
    FileExit: TAction;
    SearchFind1: TAction;
    SearchReplace1: TAction;
    HelpInfo1: TAction;
    StartRun1: TAction;
    StartSyntaxtest1: TAction;
    PageControl1: TPageControl;
    CodeTS: TTabSheet;
    ConsoleTS: TTabSheet;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    StartStep1: TAction;
    AnsichtSwitchView1: TAction;
    FindDialog1: TFindDialog;
    ReplaceDialog1: TReplaceDialog;
    EditRedo1: TAction;
    StartClearConsole1: TAction;
    PopupActionBar1: TPopupActionBar;
    PopupCut1: TMenuItem;
    PopupCopy1: TMenuItem;
    PopupPaste1: TMenuItem;
    N1: TMenuItem;
    PopupSelectAll1: TMenuItem;
    Rckgngig1: TMenuItem;
    N2: TMenuItem;
    Wiederherstellen1: TMenuItem;
    Lschen1: TMenuItem;
    StartAbort1: TAction;
    Panel1: TPanel;
    Splitter2: TSplitter;
    XPManifest1: TXPManifest;
    DataVLE: TValueListEditor;
    procedure FileNew1Execute(Sender: TObject);
    procedure FileOpen1Execute(Sender: TObject);
    procedure FileSave1Execute(Sender: TObject);
    procedure FileSaveAs1Execute(Sender: TObject);
    procedure FileExitExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure HelpInfo1Execute(Sender: TObject);
    procedure StartSyntaxtest1Execute(Sender: TObject);
    procedure StartRun1Execute(Sender: TObject);
    procedure AnsichtSwitchView1Execute(Sender: TObject);
    procedure EditRedo1Execute(Sender: TObject);
    procedure StartClearConsole1Execute(Sender: TObject);
    procedure SearchFind1Execute(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure SearchReplace1Execute(Sender: TObject);
    procedure ReplaceDialog1Replace(Sender: TObject);
    procedure StartAbort1Execute(Sender: TObject);
    procedure StartStep1Execute(Sender: TObject);
    procedure ErrorsLBDblClick(Sender: TObject);
  private
    FModified: Boolean;
    FFileName: string;
    FSyntax: TSyntax;
    FInterpreter: TMiniASMInterpreter;
    FConsole: TConsoleMemo;
    FCodeSynE: TSynEdit;
    FMiniAsmHighlighter: TSynGeneralSyn;
    FRunning: Boolean;
    function SaveQuery: TModalResult;
    procedure InterpreterReadInt(Sender: TObject; out AValue: Integer);
    procedure SetModified(const Value: Boolean);
    procedure SetFileName(const Value: string);
    procedure UpdateStatusBar;
    procedure CodeSynEChange(Sender: TObject);
    procedure CodeSynEStatusChange(Sender: TObject; Changes: TSynStatusChanges);
    // Register, Flags, Status
    procedure EAXChange(Sender: TObject; AData: Integer);
    procedure EIPChange(Sender: TObject; AData: Integer);
    procedure ZFChange(Sender: TObject; AData: Boolean);
    procedure SFChange(Sender: TObject; AData: Boolean);
    procedure StackChange(Sender: TObject; AData: array of Integer);

    procedure InterpretationComplete(Sender: TObject);
  public
    property Syntax: TSyntax read FSyntax write FSyntax;
    property Modified: Boolean read FModified write SetModified;
    property FileName: string read FFileName write SetFileName;
  end;

var
  MiniAsmFRM: TMiniAsmFRM;

implementation

uses
  About, MiniAsmChecker, SynEditTypes, SynEditSearch;

{$R *.dfm}

procedure TMiniAsmFRM.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  FMiniAsmHighlighter := TSynGeneralSyn.Create(Self);
  FMiniAsmHighlighter.Name := 'MiniAsmHighlighter';
  FMiniAsmHighlighter.DefaultFilter := 'Textdateien(*.txt)|*.txt';
  FMiniAsmHighlighter.CommentAttri.Foreground := clGreen;
  FMiniAsmHighlighter.Comments := [csBasStyle];
  FMiniAsmHighlighter.DetectPreprocessor := False;
  FMiniAsmHighlighter.IdentifierChars :=
    '!"#$%&'#39'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`' +
    'abcdefghijklmnopqrstuvwxyz{|}~'#8364#129#8218#402#8222#8230#8224#8225#710#8240#352#8249#338#141#381#143#144#8216#8217#8220#8221#8226#8211#8212#732#8482#353#8250#339#157#382#376#160 +
    #161#162#163#164#165#166#167#168#169#170#171#172#173#174#175#176#177#178#179#180#181#182#183#184#185#186#187#188#189#190#191#192#193#194#195#196#197#198#199#200#201#202#203#204#205#206#207#208#209#210#211#212#213#214#215#216#217#218#219#220#221#222#223#224 +
    #225#226#227#228#229#230#231#232#233#234#235#236#237#238#239#240#241#242#243#244#245#246#247#248#249#250#251#252#253#254#255;
  FMiniAsmHighlighter.KeyWords.Clear;
  FMiniAsmHighlighter.NumberAttri.Foreground := clBlue;

  FCodeSynE := TSynEdit.Create(CodeTS);
  FCodeSynE.Name := 'CodeSynE';
  FCodeSynE.Parent := CodeTS;
  FCodeSynE.Align := alClient;
  FCodeSynE.ActiveLineColor := 14811135;
  FCodeSynE.Font.Charset := DEFAULT_CHARSET;
  FCodeSynE.Font.Color := clWindowText;
  FCodeSynE.Font.Height := -13;
  FCodeSynE.Font.Name := 'Courier New';
  FCodeSynE.Font.Pitch := fpFixed;
  FCodeSynE.Font.Style := [];
  FCodeSynE.TabOrder := 0;
  FCodeSynE.Lines.Clear;
  FCodeSynE.PopupMenu := PopupActionBar1;
  FCodeSynE.SearchEngine := TSynEditSearch.Create(FCodeSynE);
  FCodeSynE.Highlighter := FMiniAsmHighlighter;
  FCodeSynE.Gutter.Font.Charset := DEFAULT_CHARSET;
  FCodeSynE.Gutter.Font.Color := clWindowText;
  FCodeSynE.Gutter.Font.Height := -11;
  FCodeSynE.Gutter.Font.Name := 'Courier New';
  FCodeSynE.Gutter.Font.Style := [];
  FCodeSynE.Gutter.ShowLineNumbers := True;
  FCodeSynE.Gutter.ZeroStart := True;
  FCodeSynE.Gutter.LineNumberStart := 0;
  FCodeSynE.Gutter.Gradient := True;
  FCodeSynE.Options := [eoAutoIndent, eoDragDropEditing, eoEnhanceEndKey,
    eoGroupUndo, eoScrollPastEof, eoScrollPastEol, eoShowScrollHint,
    eoSmartTabDelete, eoSmartTabs, eoTabsToSpaces];
  FCodeSynE.OnChange := CodeSynEChange;
  FCodeSynE.OnStatusChange := CodeSynEStatusChange;


  FSyntax := TSyntax.Create;
  FSyntax.LoadFromFile(ExtractFilePath(ParamStr(0)) + 'Syntax.ini');
  for i := 0 to FSyntax.StackSize -1 do
  begin
    DataVLE.Strings.Add(IntToStr(i) + '=0');
  end;

  FInterpreter := TMiniAsmInterpreter.Create(nil, FSyntax);
  FInterpreter.OnReadInt := InterpreterReadInt;
  FInterpreter.OnStackChange := StackChange;
  FInterpreter.OnEAXChange := EAXChange;
  FInterpreter.OnEIPChange := EIPChange;
  FInterpreter.OnZFChange := ZFChange;
  FInterpreter.OnSFChange := SFChange;
  FInterpreter.OnInterpretationComplete := InterpretationComplete;

  FConsole := TConsoleMemo.Create(ConsoleTS);
  FConsole.Parent := ConsoleTS;
  FConsole.Align := alClient;

  FRunning := False;
end;

procedure TMiniAsmFRM.FormDestroy(Sender: TObject);
begin
  FInterpreter.Free;
  FSyntax.Free;
end;
       
{$REGION 'File'}

function TMiniAsmFRM.SaveQuery: TModalResult;
begin
  Result := MessageDlg('Die Datei wurde gendert. Sollen die genderten Daten '
    + 'gespeichert werden?', mtConfirmation, [mbYes, mbNo, mbCancel], 0);
  if Result = mrYes then
  begin
    if SaveDialog1.Execute then
    begin
      FCodeSynE.Lines.SaveToFile(SaveDialog1.FileName);
    end
    else
    begin
      Result := mrCancel;  // nicht gespeichert
    end;
  end;
end;

procedure TMiniAsmFRM.FileNew1Execute(Sender: TObject);
var
  mres: TModalResult;
begin
  mres := mrYes;
  if Modified then
  begin
    mres := SaveQuery;
  end;

  if mres <> mrCancel then
  begin
    FCodeSynE.Clear;
    Modified := False;
    FileName := 'unbenannt';
  end;
  PageControl1.ActivePage := CodeTS;
end;

procedure TMiniAsmFRM.FileOpen1Execute(Sender: TObject);
var
  mres: TModalResult;
begin
  mres := mrYes;
  if Modified then
  begin
    mres := SaveQuery;
  end;

  if mres <> mrCancel then
  begin
    FCodeSynE.Clear;
    Modified := False;
    FileName := 'unbenannt';
    if OpenDialog1.Execute then
    begin
      FCodeSynE.Lines.LoadFromFile(OpenDialog1.FileName);
      FileName := OpenDialog1.FileName;
      Modified := False;
    end;
  end;
  PageControl1.ActivePage := CodeTS;
end;

procedure TMiniAsmFRM.FileSave1Execute(Sender: TObject);
begin
  if FileExists(FileName) then
  begin
    FCodeSynE.Lines.SaveToFile(FileName);
    Modified := False;
  end
  else
  begin
    FileSaveAs1Execute(Sender);
  end;
end;

procedure TMiniAsmFRM.FileSaveAs1Execute(Sender: TObject);
begin
  if SaveDialog1.Execute then
  begin
    fCodeSynE.Lines.SaveToFile(SaveDialog1.FileName);
    Modified := False;
    FileName := SaveDialog1.FileName;
  end;
end;

procedure TMiniAsmFRM.FileExitExecute(Sender: TObject);
begin
  Close;
end;

{$ENDREGION}

{$REGION 'Edit'}

procedure TMiniAsmFRM.EditRedo1Execute(Sender: TObject);
begin
  FCodeSynE.Redo;
end;

{$ENDREGION}

{$REGION 'View'}

procedure TMiniAsmFRM.AnsichtSwitchView1Execute(Sender: TObject);
begin
  if PageControl1.ActivePage = CodeTS then
  begin
    PageControl1.ActivePage := ConsoleTS;
  end
  else
  begin
    PageControl1.ActivePage := CodeTS;
  end;
end;

{$ENDREGION}

{$REGION 'Start'}

procedure TMiniAsmFRM.StartAbort1Execute(Sender: TObject);
begin
  FInterpreter.Terminated := True;
end;

procedure TMiniAsmFRM.StartClearConsole1Execute(Sender: TObject);
begin
  FConsole.Clear;
end;

procedure TMiniAsmFRM.StartRun1Execute(Sender: TObject);
var
  checker: TMiniAsmChecker;
  SyntaxOK: Boolean;
begin
  StartRun1.Enabled := False;
  StartSyntaxtest1.Enabled := False;
  StartStep1.Enabled := False;
  StartAbort1.Enabled := True;
  try
    checker := TMiniAsmChecker.Create(FCodeSynE.Lines, FSyntax);
    try
      ErrorsLB.Items.Clear;
      SyntaxOK := checker.Execute(ErrorsLB.Items);
      if SyntaxOK then
        ErrorsLB.Items.Add('--- keine Syntax-Fehler gefunden ---');
    finally
      checker.Free;
    end;

    if SyntaxOK then
    begin
      FRunning := True;
      FInterpreter.Source := FCodeSynE.Lines;
      PageControl1.ActivePage := ConsoleTS;
      FConsole.SetFocus;
      FInterpreter.Execute(FConsole.Lines);
      FRunning := False;
    end;
  finally
    StartRun1.Enabled := True;
    StartSyntaxtest1.Enabled := True;
    StartStep1.Enabled := True;
    StartAbort1.Enabled := False;
  end;
end;

procedure TMiniAsmFRM.StartStep1Execute(Sender: TObject);
var
  checker: TMiniAsmChecker;
  SyntaxOK: Boolean;
begin
  StartRun1.Enabled := False;
  StartSyntaxtest1.Enabled := False;
  StartStep1.Enabled := False;
  StartAbort1.Enabled := True;
  try                         
    checker := TMiniAsmChecker.Create(FCodeSynE.Lines, FSyntax);
    try
      ErrorsLB.Items.Clear;
      SyntaxOK := checker.Execute(ErrorsLB.Items);
      if SyntaxOK then
        ErrorsLB.Items.Add('--- keine Syntax-Fehler gefunden ---');
    finally
      checker.Free;
    end;

    if SyntaxOK then
    begin
      if not FRunning then
      begin
        FInterpreter.Source := FCodeSynE.Lines;
      end;
      FRunning := True;
      PageControl1.ActivePage := ConsoleTS;
      FConsole.SetFocus;
      FInterpreter.Step(FConsole.Lines);
    end
    else
    begin
      StartRun1.Enabled := True;
      StartSyntaxtest1.Enabled := True;
      StartStep1.Enabled := True;
      StartAbort1.Enabled := False;
    end;
  finally
    StartStep1.Enabled := True;       
  end;
end;

procedure TMiniAsmFRM.StartSyntaxtest1Execute(Sender: TObject);
var
  checker: TMiniAsmChecker;
begin
  StartRun1.Enabled := False;
  StartSyntaxtest1.Enabled := False;
  try
    checker := TMiniAsmChecker.Create(FCodeSynE.Lines, FSyntax);
    try
      ErrorsLB.Items.Clear;
      if checker.Execute(ErrorsLB.Items) then
        ErrorsLB.Items.Add('--- keine Syntax-Fehler gefunden ---');
    finally
      checker.Free;
    end;
  finally
    StartRun1.Enabled := True;
    StartSyntaxtest1.Enabled := True;
  end;
end;

procedure TMiniAsmFRM.InterpreterReadInt(Sender: TObject; out AValue: Integer);
begin
  FConsole.Lines.Add('Bitte geben Sie eine Zahl ein: ');
  FConsole.SetFocus;
  AValue := FConsole.ReadInt;
end;

procedure TMiniAsmFRM.InterpretationComplete(Sender: TObject);
begin
  FRunning := False;
  StartRun1.Enabled := True;
  StartSyntaxtest1.Enabled := True;
  StartAbort1.Enabled := False;
  FConsole.Lines.Add('--- Programmende ---');
  FConsole.Lines.Add('');
  FConsole.Lines.Add('');
end;

{$ENDREGION}

{$REGION 'Help'}

procedure TMiniAsmFRM.HelpInfo1Execute(Sender: TObject);
var
  AboutFRM: TAboutFRM;
begin
  AboutFRM := TAboutFRM.Create(nil);
  try
    AboutFRM.ShowModal(FSyntax);
  finally
    AboutFRM.Free;
  end;
end;

{$ENDREGION}

{$REGION 'Status'}

procedure TMiniAsmFRM.UpdateStatusBar;
const
  ModifiedStrings: array[Boolean] of string = ('', 'gendert');
  InsertModeStrings: array[Boolean] of string = ('berschreiben', 'Einfgen');
begin
  StatusBar1.Panels[0].Text := Format('Zeile: %d  Spalte: %d',
    [FCodeSynE.CaretY -1, FCodeSynE.CaretX -1]);
  StatusBar1.Panels[1].Text := ModifiedStrings[FCodeSynE.Modified];
  StatusBar1.Panels[2].Text := InsertModeStrings[FCodeSynE.InsertMode];
end;

procedure TMiniAsmFRM.CodeSynEChange(Sender: TObject);
begin
  EditRedo1.Enabled := FCodeSynE.CanRedo;
end;

procedure TMiniAsmFRM.CodeSynEStatusChange(Sender: TObject;
  Changes: TSynStatusChanges);
begin
  UpdateStatusBar;
  FCodeSynE.ActiveLineColor := 14811135;
end;

{$ENDREGION}

{$REGION 'Search'}

procedure TMiniAsmFRM.SearchFind1Execute(Sender: TObject);
begin
  FindDialog1.Execute;
end;

procedure TMiniAsmFRM.SearchReplace1Execute(Sender: TObject);
begin
  ReplaceDialog1.Execute;
end;

procedure TMiniAsmFRM.FindDialog1Find(Sender: TObject);
var
  rOptions: TSynSearchOptions;
  dlg: TFindDialog;
  sSearch: string;
begin
  if Sender = ReplaceDialog1 then
    dlg := ReplaceDialog1
  else
    dlg := FindDialog1;
  sSearch := dlg.FindText;
  if Length(sSearch) = 0 then
  begin
    Beep;
  end
  else
  begin
    rOptions := [];
    if not (frDown in dlg.Options) then
      Include(rOptions, ssoBackwards);
    if frMatchCase in dlg.Options then
      Include(rOptions, ssoMatchCase);
    if frWholeWord in dlg.Options then
      Include(rOptions, ssoWholeWord);
    if FCodeSynE.SearchReplace(sSearch, '', rOptions) = 0 then
    begin
      Beep;
      ShowMessage(Format('"%s" kann nicht gefunden werden!', [sSearch]));
    end;
  end;
end;

procedure TMiniAsmFRM.ReplaceDialog1Replace(Sender: TObject);
var
  rOptions: TSynSearchOptions;
  sSearch: string;
begin
  sSearch := ReplaceDialog1.FindText;
  if Length(sSearch) = 0 then begin
    Beep;
  end
  else
  begin
    rOptions := [ssoReplace];
    if frMatchCase in ReplaceDialog1.Options then
      Include(rOptions, ssoMatchCase);
    if frWholeWord in ReplaceDialog1.Options then
      Include(rOptions, ssoWholeWord);
    if frReplaceAll in ReplaceDialog1.Options then
      Include(rOptions, ssoReplaceAll);
    if FCodeSynE.SearchReplace(sSearch, ReplaceDialog1.ReplaceText,
      rOptions) = 0  then
    begin
      Beep;
      ShowMessage(Format('"%s" konnte nicht ersetzt werden!', [sSearch]));
    end;
  end;
end;

{$ENDREGION}

{$REGION 'Register, Flags, Stack'}

procedure TMiniAsmFRM.EAXChange(Sender: TObject; AData: Integer);
begin
  DataVLE.Strings.Values['Akkumulator (EAX)'] := IntToStr(AData);
end;

procedure TMiniAsmFRM.EIPChange(Sender: TObject; AData: Integer);
begin
  DataVLE.Strings.Values['InstructionPointer (EIP)'] := IntToStr(AData);
end;

procedure TMiniAsmFRM.ZFChange(Sender: TObject; AData: Boolean);
begin
  DataVLE.Strings.Values['ZeroFlag (ZF)'] := BoolToStr(AData, True);
end;

procedure TMiniAsmFRM.SFChange(Sender: TObject; AData: Boolean);
begin
  DataVLE.Strings.Values['SignFlag (SF)'] := BoolToStr(AData, True);
end;

procedure TMiniAsmFRM.StackChange(Sender: TObject; AData: array of Integer);
var
  i: Integer;
begin
  for i := 0 to High(AData) do
  begin
    DataVLE.Strings.Values[IntToStr(i)] := IntToStr(AData[i]);
  end;
end;

{$ENDREGION}

{$REGION 'Getter & Setter'}

procedure TMiniAsmFRM.SetModified(const Value: Boolean);
begin
  FCodeSynE.Modified := Value;
  UpdateStatusBar;
end;

procedure TMiniAsmFRM.SetFileName(const Value: string);
begin
  FFileName := Value;
  Caption := 'MiniAsm32 - ' + Value;
end;

{$ENDREGION}

procedure TMiniAsmFRM.ErrorsLBDblClick(Sender: TObject);
var
  line: string;
  line_num: Integer;
  Position: Integer;
  Count: Integer;
begin
  if ErrorsLB.ItemIndex > -1 then
  begin
    Position := Pos('[Zeile: ', ErrorsLB.Items[ErrorsLB.ItemIndex]);
    if Position > 0 then
    begin
      Position := Position + 8;
      Count := Pos(']', ErrorsLB.Items[ErrorsLB.ItemIndex]) - Position;
      line := Copy(ErrorsLB.Items[ErrorsLB.ItemIndex], Position, Count);
      line_num := StrToIntDef(line, FCodeSynE.Lines.Count -1);
      FCodeSynE.GotoLineAndCenter(line_num +1);
      FCodeSynE.ActiveLineColor := clRed;
      FCodeSynE.SetFocus;
    end;
  end;
end;

end.
