{******************************************************************************}
{                                                                              }
{                                ChildWin                                      }
{                                                                              }
{   The MDIChild-Form of PasViewer.                                            }
{                                                                              }
{   original author:   Christian Rehn aka r2c2                                 }
{                                                                              }
{   This code is licenced under the terms of the Mozilla Public Licence(MPL)   }
{   See http://www.mozilla.org/MPL/ or licence-file included in source-archive }
{   for licence terms.                                                         }
{                                                                              }
{******************************************************************************}


unit ChildWin;

interface

uses Windows, Classes, Graphics, Forms, Controls, StdCtrls, SynEdit,
  SynEditHighlighter, SynHighlighterPas, SynHighlighterDfm, TMdiTabs_class;

type
  TMDIChild = class(TTabedMdiChild)
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
  private
    FEditor: TSynEdit;
    FPasHighlighter: TSynPasSyn;
    FDfmHighlighter: TSynDfmSyn;
  public
    property Editor: TSynEdit read FEditor;
    procedure LoadFile(const AFileName: string);
  end;

implementation

uses
  SynEditSearch, SysUtils;

{$R *.dfm}

procedure TMDIChild.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TMDIChild.FormCreate(Sender: TObject);
begin
  FEditor := TSynEdit.Create(Self);
  FEditor.Align := alClient;
  FEditor.ActiveLineColor := 14811135;
  FEditor.Lines.Clear;
  FEditor.Gutter.ShowLineNumbers := True;
  FEditor.Gutter.Gradient := True;
  FEditor.Options := [eoAutoIndent, eoDragDropEditing, eoEnhanceEndKey,
    eoGroupUndo, eoScrollPastEof, eoScrollPastEol, eoShowScrollHint,
    eoSmartTabDelete, eoSmartTabs, eoTabsToSpaces];
  FEditor.ReadOnly := True;
  FEditor.WordWrap := True;

  FPasHighlighter := TSynPasSyn.Create(FEditor);
  FPasHighlighter.StringAttribute.Foreground := clBlue;
  FPasHighlighter.KeywordAttribute.Foreground := clNavy;
  FPasHighlighter.CommentAttribute.Foreground := clGreen;
  FPasHighlighter.DirectiveAttri.Foreground := clTeal;
  FPasHighlighter.DirectiveAttri.Style := [];
  FPasHighlighter.NumberAttri.Foreground := clBlue;
  FPasHighlighter.DelphiVersion := dvDelphi2005;

  FDfmHighlighter := TSynDfmSyn.Create(FEditor);
  FDfmHighlighter.StringAttribute.Foreground := clBlue;
  FDfmHighlighter.KeywordAttribute.Foreground := clNavy;
  FDfmHighlighter.CommentAttribute.Foreground := clGreen;
  FDfmHighlighter.NumberAttri.Foreground := clBlue;

  FEditor.SearchEngine := TSynEditSearch.Create(FEditor);

  FEditor.Parent := Self;
end;

// Loads the given file into the SynEdit component.
procedure TMDIChild.LoadFile(const AFileName: string);
var
  dummy: Boolean;
begin
  if FileExists(AFileName) then
  begin
    if (AnsiLowerCase(ExtractFileExt(AFileName)) = '.dfm') or
      (AnsiLowerCase(ExtractFileExt(AFileName)) = '.nfm') or
      (AnsiLowerCase(ExtractFileExt(AFileName)) = '.frm') then
    begin
      LoadDFMFile2Strings(AFileName, FEditor.Lines, dummy);
      FEditor.Highlighter := FDfmHighlighter;
    end
    else
    begin
      FEditor.Lines.LoadFromFile(AFileName);
      FEditor.Highlighter := FPasHighlighter;
    end;
  end;
end;

end.
