{******************************************************************************}
{                                                                              }
{                                Main                                          }
{                                                                              }
{   The main-form of PasViewer.                                                }
{                                                                              }
{   original author:   Christian Rehn aka r2c2                                 }
{                                                                              }
{   This code is licenced under the terms of the Mozilla Public Licence(MPL)   }
{   See http://www.mozilla.org/MPL/ or licence-file included in source-archive }
{   for licence terms.                                                         }
{                                                                              }
{******************************************************************************}

//TODO: Optionen ==> WordWarp, etc.
//TODO: dfm-Vorschau
//TODO: RegEX-Suche
//TODO: suche in mehreren Dateien
unit Main;

interface

uses
  Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls, StdActns,
  ActnList, ToolWin, ImgList, ActnCtrls, ActnMan, ActnMenus, XPStyleActnCtrls,
  TMdiTabs_class, TPersistentFormPos_class;

type
  TMainForm = class(TForm)
    StatusBar: TStatusBar;
    ImageList1: TImageList;
    ActionManager1: TActionManager;
    ActionMainMenuBar1: TActionMainMenuBar;
    ActionToolBar1: TActionToolBar;
    EditCopy2: TEditCopy;
    EditSelectAll1: TEditSelectAll;
    WindowCascade2: TWindowCascade;
    WindowTileHorizontal2: TWindowTileHorizontal;
    WindowTileVertical2: TWindowTileVertical;
    WindowMinimizeAll2: TWindowMinimizeAll;
    FileOpen2: TAction;
    FileExit2: TFileExit;
    FileClose: TAction;
    HelpAbout: TAction;
    FindDialog1: TFindDialog;
    EditFind: TAction;
    OpenDialog: TOpenDialog;
    ViewWordWrap: TAction;
    ViewSaveFormPos: TAction;
    procedure FileCloseExecute(Sender: TObject);
    procedure HelpAboutExecute(Sender: TObject);
    procedure FileOpen2Execute(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
    procedure EditFindExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FileCloseUpdate(Sender: TObject);
    procedure EditFindUpdate(Sender: TObject);
    procedure ViewWordWrapExecute(Sender: TObject);
    procedure ViewSaveFormPosExecute(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FTabs: TMdiTabs;
    FWordWrap: Boolean;
    FSaveFormPos: Boolean;
    FFormPos: TPersistentFormPos;
    procedure CreateMDIChild(const Name: string);
  public

  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

uses CHILDWIN, about, SynEditTypes;

procedure TMainForm.CreateMDIChild(const Name: string);
var
  Child: TMDIChild;
begin
  Child := TMDIChild.Create(Application);
  Child.Caption := Name;
  Child.Hint := Name;
  Child.TabName := ExtractFileName(Name);
  FTabs.AddChild(Child);
  Child.LoadFile(Name);
  Child.Editor.WordWrap := FWordWrap;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  FTabs := TMdiTabs.Create(self);
  FTabs.Top := 50;
  FTabs.Parent := Self;
  FTabs.Color := clBtnFace;
  FWordWrap := True;
  FSaveFormPos := False;

  FFormPos := TPersistentFormPos.Create(Self);
  FSaveFormPos := FFormPos.LoadFormPos;
  ViewSaveFormPos.Checked := FSaveFormPos;
  if not FSaveFormPos then
    Position := poScreenCenter; // default if no Data found
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  if FSaveFormPos then
    FFormPos.SaveFormPos;
  FFormPos.Free;
end;

{$REGION 'File'}

procedure TMainForm.FileOpen2Execute(Sender: TObject);
var
  i: Integer;
begin
  if OpenDialog.Execute then
  begin
    for i := 0 to OpenDialog.Files.Count - 1 do
    begin
      CreateMDIChild(OpenDialog.Files[i]);
    end;
  end;
end;

procedure TMainForm.FileCloseExecute(Sender: TObject);
begin
  ActiveMDIChild.Close;
end;

procedure TMainForm.FileCloseUpdate(Sender: TObject);
begin
  FileClose.Enabled := (MDIChildCount > 0);
end;

{$ENDREGION}

{$REGION 'Find'}

procedure TMainForm.EditFindExecute(Sender: TObject);
begin
  FindDialog1.Execute;
end;

procedure TMainForm.EditFindUpdate(Sender: TObject);
begin
  EditFind.Enabled := (MDIChildCount > 0);
end;

procedure TMainForm.FindDialog1Find(Sender: TObject);
var
  rOptions: TSynSearchOptions;
  dlg: TFindDialog;
  sSearch: string;
begin
  dlg := FindDialog1;
  sSearch := dlg.FindText;
  if Length(sSearch) = 0 then
  begin
    Beep;
  end
  else
  begin
    rOptions := [];
    if not (frDown in dlg.Options) then
      Include(rOptions, ssoBackwards);
    if frMatchCase in dlg.Options then
      Include(rOptions, ssoMatchCase);
    if frWholeWord in dlg.Options then
      Include(rOptions, ssoWholeWord);
    if TMdiChild(ActiveMDIChild).Editor.SearchReplace(sSearch, '', rOptions) = 0 then
    begin
      Beep;
      ShowMessage(Format('"%s" kann nicht gefunden werden!', [sSearch]));
    end;
  end;
end;

{$ENDREGION}

{$REGION 'View'}

procedure TMainForm.ViewSaveFormPosExecute(Sender: TObject);
begin
  FSaveFormPos := not FSaveFormPos;
  ViewSaveFormPos.Checked := FSaveFormPos;
  if not FSaveFormPos then
  begin
    FFormPos.RemoveFiles;
  end;
end;

procedure TMainForm.ViewWordWrapExecute(Sender: TObject);
var
  i: Integer;
begin
  FWordWrap := not FWordWrap;
  ViewWordWrap.Checked := FWordWrap;
  for i := 0 to MDIChildCount - 1 do
  begin
    TMDIChild(MDIChildren[i]).Editor.WordWrap := FWordWrap;
  end;
end;

{$ENDREGION}

procedure TMainForm.HelpAboutExecute(Sender: TObject);
var
  AboutBox: TAboutBox;
begin
  AboutBox := TAboutBox.Create(nil);
  try
    AboutBox.ShowModal;
  finally
    AboutBox.Free;
  end;
end;

end.
