/**
 * This file is part of InterpreterDemo. Use it for every purpose, you like.
 * Cosider this code as public domain.
 *
 * \author Christian Rehn
 */

#include "Interpreter.h"

#include <assert.h>

namespace InterpreterDemo
{

	NumberExpression::NumberExpression(int number)
		: _number(number)
	{

	}

	int NumberExpression::interpret() const
	{
		return _number;
	}

	InversionExpression::InversionExpression(Expression* term)
		: _term(term)
	{
		assert(term);
	}

	InversionExpression::~InversionExpression()
	{
		delete _term;
	}

	int InversionExpression::interpret() const
	{
		return -1 * _term->interpret();
	}

	AdditionExpression::AdditionExpression(Expression* firstAddend,
										 Expression* secondAddend)
		: _firstAddend(firstAddend),
			_secondAddend(secondAddend)
	{
		assert(firstAddend);
		assert(secondAddend);
	}
	
	AdditionExpression::~AdditionExpression()
	{
		delete _firstAddend;
		delete _secondAddend;
	}

	int AdditionExpression::interpret() const
	{
		return _firstAddend->interpret() + _secondAddend->interpret();
	}

	SubtractionExpression::SubtractionExpression(Expression* minuend,
												 Expression* subtrahend)
		: _minuend(minuend),
			_subtrahend(subtrahend)
	{
		assert(minuend);
		assert(subtrahend);
	}

	SubtractionExpression::~SubtractionExpression()
	{
		delete _minuend;
		delete _subtrahend;
	}

	int SubtractionExpression::interpret() const
	{
		return _minuend->interpret() - _subtrahend->interpret();
	}

	MultiplicationExpression::MultiplicationExpression(Expression* firstFactor,
													 Expression* secondFactor)
		: _firstFactor(firstFactor),
			_secondFactor(secondFactor)
	{
		assert(firstFactor);
		assert(secondFactor);
	}

	MultiplicationExpression::~MultiplicationExpression()
	{
		delete _firstFactor;
		delete _secondFactor;
	}

	int MultiplicationExpression::interpret() const
	{
		return _firstFactor->interpret() * _secondFactor->interpret();
	}

	DivisionExpression::DivisionExpression(Expression* dividend,
										 Expression* divisor)
		: _dividend(dividend),
			_divisor(divisor)
	{
		assert(dividend);
		assert(divisor);
	}

	DivisionExpression::~DivisionExpression()
	{
		delete _dividend;
		delete _divisor;
	}

	int DivisionExpression::interpret() const
	{
		return _dividend->interpret() / _divisor->interpret();
	}

}