/**
 * This file is part of InterpreterDemo. Use it for every purpose, you like.
 * Cosider this code as public domain.
 *
 * \author Christian Rehn
 */

#define BOOST_TEST_MAIN
#include <boost/test/included/unit_test.hpp>
#include <boost/test/test_tools.hpp>

#include "../Tokenizer.h"

using namespace InterpreterDemo;

BOOST_AUTO_TEST_CASE(getNextTokenTest)
{
	Tokenizer tokenizer("42-+*/()");

	Token token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(token, "Number");
	BOOST_CHECK_EQUAL(tokenizer.getCurrentNumberTokenValue(), 42);

	token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(token, "Minus");

	token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(token, "Plus");

	token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(token, "Times");

	token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(token, "Divide");

	token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(token, "LeftParenthesis");

	token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(token, "RightParenthesis");
	
	token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(token, "");
}

BOOST_AUTO_TEST_CASE(setgetStrTest)
{
	Tokenizer tokenizer("42-+*/");
	BOOST_CHECK_EQUAL(tokenizer.getStr(), "42-+*/");
	tokenizer.getNextToken();
	tokenizer.setStr("42-3*7+22");
	BOOST_CHECK_EQUAL(tokenizer.getStr(), "42-3*7+22");
}

BOOST_AUTO_TEST_CASE(hasNextTest)
{
	Tokenizer tokenizer("42");
	BOOST_CHECK(tokenizer.hasNext());
	tokenizer.getNextToken();
	BOOST_CHECK(! tokenizer.hasNext());
}

BOOST_AUTO_TEST_CASE(getNextTokenFailingTest)
{
	Tokenizer tokenizer("a");
	bool ok = false;
	try
	{
		tokenizer.getNextToken();
	}
	catch(const TokenizerException& e)
	{
		ok = true;
	}
	BOOST_CHECK(ok);

	ok = false;

	tokenizer.setStr("42+3a");
	tokenizer.getNextToken();
	tokenizer.getNextToken();
	tokenizer.getNextToken();
	try
	{
		tokenizer.getNextToken();
	}
	catch(const TokenizerException& e)
	{
		ok = true;
	}
	BOOST_CHECK(ok);
}

BOOST_AUTO_TEST_CASE(getCurrent)
{
	Tokenizer tokenizer("42-3*7");
	BOOST_CHECK_EQUAL(tokenizer.getCurrentToken(), "");

	Token token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(tokenizer.getCurrentToken(), token);
	BOOST_CHECK_EQUAL(tokenizer.getCurrentNumberTokenValue(), 42);
	BOOST_CHECK_EQUAL(tokenizer.getCurrentTokenAsStr(), "Number 42");

	token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(tokenizer.getCurrentToken(), token);
	BOOST_CHECK_EQUAL(tokenizer.getCurrentTokenAsStr(), "Minus");

	token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(tokenizer.getCurrentToken(), token);
	BOOST_CHECK_EQUAL(tokenizer.getCurrentNumberTokenValue(), 3);
	BOOST_CHECK_EQUAL(tokenizer.getCurrentTokenAsStr(), "Number 3");

	token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(tokenizer.getCurrentToken(), token);
	BOOST_CHECK_EQUAL(tokenizer.getCurrentTokenAsStr(), "Times");

	token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(tokenizer.getCurrentToken(), token);
	BOOST_CHECK_EQUAL(tokenizer.getCurrentNumberTokenValue(), 7);
	BOOST_CHECK_EQUAL(tokenizer.getCurrentTokenAsStr(), "Number 7");

	token = tokenizer.getNextToken();
	BOOST_CHECK_EQUAL(tokenizer.getCurrentToken(), token);
	BOOST_CHECK_EQUAL(tokenizer.getCurrentTokenAsStr(), "");
}