/**
 * This file is part of InterpreterDemo. Use it for every purpose, you like.
 * Cosider this code as public domain.
 *
 * \author Christian Rehn
 */

#define BOOST_TEST_MAIN
#include <boost/test/included/unit_test.hpp>
#include <boost/test/test_tools.hpp>

#include "../Tokenizer.h"
#include "../Parser.h"
#include "../Interpreter.h"

using namespace InterpreterDemo;

BOOST_AUTO_TEST_CASE(parseTest1)
{
	Tokenizer tokenizer("42-3*7+22");
	Parser parser(tokenizer);
	Expression* expr = parser.parse();
	BOOST_CHECK_EQUAL(expr->interpret(), 43);
}

BOOST_AUTO_TEST_CASE(parseTest2)
{
	Tokenizer tokenizer("(42-3)*7+22");
	Parser parser(tokenizer);
	Expression* expr = parser.parse();
	BOOST_CHECK_EQUAL(expr->interpret(), 295);
}

BOOST_AUTO_TEST_CASE(parseTest3)
{
	Tokenizer tokenizer("42-(-3)*7+22");
	Parser parser(tokenizer);
	Expression* expr = parser.parse();
	BOOST_CHECK_EQUAL(expr->interpret(), 85);
}

BOOST_AUTO_TEST_CASE(parseWithArgTest)
{
	Tokenizer tokenizer;
	Parser parser(tokenizer);
	Expression* expr = parser.parse("42-(-3)*7+22");
	BOOST_CHECK_EQUAL(expr->interpret(), 85);
}

BOOST_AUTO_TEST_CASE(parseFailingTest)
{
	Tokenizer tokenizer("42--3*7+22");
	Parser parser(tokenizer);

	bool ok = false;
	try
	{
		Expression* expr = parser.parse();
	}
	catch(const ParserException& e)
	{
		ok = true;
	}
	BOOST_CHECK(ok);
}